﻿using Newtonsoft.Json.Linq;
using Tinycc.Helpers;

namespace Tinycc;

public class Request
{
    // Tinycc resource address
    public string Resource { get; set; }

    // Every filter should be string values. So Integer will be cast into Strings
    public IDictionary<string, string> Filters { get; set; } = new Dictionary<string, string>();

    // The request body is a JObject that will be cast into a String before the call
    public JObject Body { get; set; } = new JObject();

    // The request body is a JArray that will be cast into a String before the call
    public JArray BodyList { get; set; } = new JArray();

    public Request(string resource)
    {
        Resource = resource;
    }

    public Request Filter(string key, string value)
    {
        Filters.Add(key, value);
        return this;
    }

    public Request Filter(string key, int value)
    {
        return Filter(key, value.ToString());
    }

    public Request Property(string key, Object value)
    {
        Body.Add(key, new JValue(value));
        return this;
    }

    public Request Property(string key, JToken value)
    {
        Body.Add(key, value);
        return this;
    }

    public string BuildUrl()
    {
        string url = UrlHelper.CombineUrl(Constants.DefaultBaseAdress, Resource ?? string.Empty);
        return UrlHelper.AddQuerryString(url, Filters);
    }

    public override string ToString()
    {
        dynamic jObject = new JObject();
        jObject.Resource = Resource;
        jObject.Filters = JObject.FromObject(Filters);
        jObject.Body = Body;
        return jObject.ToString();
    }
}
